/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.validation;

import eu.europa.ec.taxud.cesop.domain.ValidationError;

/**
 * General CESOP runtime exception.
 */
public class CesopValidationException extends RuntimeException {
    private static final long serialVersionUID = 4234396838057335400L;
    private final ValidationError validationError;

    /**
     * Instantiates a new Cesop validation exception.
     *
     * @param message         the message
     * @param validationError the validation error
     */
    public CesopValidationException(final String message, final ValidationError validationError) {
        super(message);
        this.validationError = validationError;
    }

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public CesopValidationException(final String message) {
        super(message);
        this.validationError = null;
    }

    /**
     * Constructor.
     *
     * @param message message the exception message
     * @param cause   the exception cause
     */
    public CesopValidationException(final String message, final Throwable cause) {
        super(message, cause);
        this.validationError = null;
    }

    /**
     * Gets validation error.
     *
     * @return the validation error
     */
    public ValidationError getValidationError() {
        return this.validationError;
    }
}
